import sys
from collections import Counter, defaultdict

def resi():
    # Funkcija za citanje ulaza koja odmah reaguje
    def uzmi_podatke():
        sve_brojke = []
        while True:
            try:
                linija = input().replace(',', ' ')
                delovi = linija.split()
                if not delovi: continue
                for d in delovi:
                    sve_brojke.append(int(d))
                # Ako imamo N i sve koordinate (2*N), prekidamo unos
                if len(sve_brojke) >= 1 and len(sve_brojke) >= 1 + 2 * sve_brojke[0]:
                    break
            except EOFError:
                break
        return sve_brojke

    podaci = uzmi_podatke()
    if not podaci: return
    
    n = podaci[0]
    tacke = []
    for i in range(n):
        x = podaci[1 + 2*i]
        y = podaci[1 + 2*i + 1]
        tacke.append((x, y))

    # Grupišemo iste lokacije (ako više ljudi krece sa iste tacke)
    brojac = Counter(tacke)
    ukupno_pozdrava = 0

    # GRUPISANJE ZA SUSRETE U t > 0
    h_grupe = defaultdict(list)   # Ista y, ista parnost x (E-W susret)
    v_grupe = defaultdict(list)   # Ista x, ista parnost y (N-S susret)
    d1_grupe = defaultdict(list)  # x + y = konstanta (N-E i S-W susret)
    d2_grupe = defaultdict(list)  # y - x = konstanta (N-W i S-E susret)

    for (x, y), k in brojac.items():
        h_grupe[(y, x % 2)].append(k)
        v_grupe[(x, y % 2)].append(k)
        d1_grupe[x + y].append(k)
        d2_grupe[y - x].append(k)

    def suma_parova(lista):
        if len(lista) < 2: return 0
        s = sum(lista)
        s2 = sum(i*i for i in lista)
        # Racuna sumu proizvoda k_i * k_j za sve parove u grupi
        return (s * s - s2) // 2

    # Horizontalni i vertikalni susreti donose po 1 pozdrav po paru lokacija
    for g in h_grupe.values(): ukupno_pozdrava += suma_parova(g)
    for g in v_grupe.values(): ukupno_pozdrava += suma_parova(g)

    # Dijagonalni susreti donose po 2 pozdrava po paru lokacija
    for g in d1_grupe.values(): ukupno_pozdrava += 2 * suma_parova(g)
    for g in d2_grupe.values(): ukupno_pozdrava += 2 * suma_parova(g)

    print(ukupno_pozdrava)

if __name__ == "__main__":
    resi()